<?php
// implement tinymce button
	
function pcma_tinymce_emoji_init() {
	if(!current_user_can('edit_posts') && !current_user_can('edit_pages')) {
		return;
    }

    // restrict emoji btn only to settings and email campaigns
    global $current_screen;
    if(is_object($current_screen) && ($current_screen->base == 'pvtcont-add-ons_page_pcma_settings' || $current_screen->id == "pcma_email_campaigns")) {
    
        if(get_user_option('rich_editing') == 'true') {
            add_filter('mce_external_plugins', 'pcma_tinymce_emoji_plugin');
            add_filter('mce_buttons', 'pcma_tinymce_emoji_btn');
            add_action('admin_footer', 'pcma_tinymce_emoji_n_preview_tricks');
        }
    }
}
add_action('current_screen', 'pcma_tinymce_emoji_init');


	

function pcma_tinymce_emoji_plugin( $plugins ) {
	$plugins['pcma_tinymce_emoji'] = PCMA_URL .'/js/tinymce_emoji_btn.js?v='. PCMA_VER;
	return $plugins;
}

function pcma_tinymce_emoji_btn($buttons) {
	array_push( $buttons, '|', 'pcma-lc-emoji-picker');
	return $buttons;
}




// appending JS code to setup preview engine and emojis to targeted WP editors
function pcma_tinymce_emoji_n_preview_tricks() {
    $current_user = wp_get_current_user();
    ?>
    <script type="text/javascript">
    (function($) { 
        "use strict";
        
        const nonce = '<?php echo wp_create_nonce('lcwp_nonce') ?>';
        let active_trigger;
        
        
        window.pcma_common_emoji_opts = {
            trigger_position : {
                top : '6px',
                right: '8px',
            },
            trigger_size : {
                width : '22px',
                height: '22px',
            },
            labels : [ 
                `<?php esc_attr_e('insert emoji', PCMA_ML) ?>`,
                `<?php esc_attr_e('search emoji', PCMA_ML) ?>`,
                `<?php esc_attr_e('.. no results ..', PCMA_ML) ?>`,
            ],
            target_r_padding    : 28, 
            emoji_json_url      : '<?php echo PCMA_URL ?>/js/lc-emoji-picker/emoji-list.min.json',
        };
        
        
        
        // manage the tinyMCE block to have emoji picker and preview + demo-send tab
        window.pcma_setup_tinymce_emoji_n_preview = function(editor_id = '', title_f_name = '', linked_template_f_name = '') {
            const $wrap = (editor_id) ? $('#wp-'+ editor_id +'-wrap') : $('.wp-editor-wrap');
            if(!$wrap.length) {
                return false;    
            }

            setTimeout(function() {
                // tweak interface
                $wrap.find('.mce-i-wp_more, .mce-i-outdent, .mce-i-indent').parents('.mce-btn').remove();
                
                $wrap.find('#qt_content_close').after(`<input type="text" name="pcma_tept_txtmode_field" class="ed_button button button-small pcma_tept_txtmode_field" value="" autocomplete="off" />`);
                
                $wrap.find('.switch-html').after(`
                <button type="button" class="wp-switch-editor pcma-tinymce-demosend" data-editor-id="${ editor_id }" data-title-f="${ title_f_name }" data-linked-template-f="${ linked_template_f_name }">
                    <span class="dashicons dashicons-email-alt" title="<?php esc_attr_e('send demo e-mail', PCMA_ML) ?>"></span>
                </button>`);
                
                $wrap.find('.switch-html').after(`<button type="button" class="wp-switch-editor pcma-tinymce-preview-tab" data-editor-id="${ editor_id }" data-linked-template-f="${ linked_template_f_name }"><?php esc_attr_e('Preview', PCMA_ML) ?></button>`);
                
                $wrap.attr('data-pcma-linked-template-f', linked_template_f_name);
                $wrap.append(`<iframe class="pcma-mce-preview" src="" style="background-image: url(<?php echo site_url('/wp-admin/images/spinner-2x.gif') ?>);" />`);
                
                
                // apply emoji picker (text mode only)
                let emoji_opts = JSON.parse(JSON.stringify(window.pcma_common_emoji_opts));
                
                emoji_opts.trigger_position.top = '2px';
                emoji_opts.selection_callback = function(emoji, target_field) {
                    
                    const $textarea = $(target_field).parents('.wp-editor-wrap').find('textarea.wp-editor-area'),
                          true_emoji = emoji.querySelector('img').getAttribute('alt');
                    
                    $textarea.val( $textarea.val() + true_emoji);
                };
                new lc_emoji_picker('.pcma_tept_txtmode_field', emoji_opts);
                new lc_emoji_picker('input[name="'+ title_f_name +'"]');
            }, 70);
        };
        
        
        
        
        // send demo e-mail
        $(document).on('click', '.pcma-tinymce-demosend:not(.pcma_mce_demosending)', function() {
            const $tab = $(this),
                  $wrap = $tab.parents('.wp-editor-wrap'),
                  editor_mode   = ($wrap.hasClass('tmce-active')) ? 'mce' : 'text',
                  editor_id = $tab.data('editor-id'),
                  linked_template_f_name = $tab.data('linked-template-f');
            
            
            // trick to be sure contents are always up-to-date when mail is sent while viewing the preview
            if($wrap.hasClass('pcma-mce-preview-active')) {
                $wrap.find('.wp-switch-editor.switch-html').trigger('click');
                
                setTimeout(function() {
                    $wrap.find('.pcma-tinymce-preview-tab').trigger('click');
                }, 50);
            }
            
            
            // get title
            const title = ($('input[name="'+ $tab.data('title-f') +'"]').length) ? $('input[name="'+ $tab.data('title-f') +'"]').val().trim() : '';
            
            // get editor content
            let contents = '';
            if(!editor_id) { // wp posts
                contents = (editor_mode == 'mce') ? tinyMCE.activeEditor.getContent() : $('textarea.wp-editor-area').val().trim();  
            } 
            else if(typeof(tinyMCE.editors[editor_id]) != 'undefined' || $('#'+editor_id).length) {
                contents = (editor_mode == 'mce') ? tinyMCE.editors[editor_id].getContent() : $('#'+editor_id).val().trim();
            }
            
            if(!title || !contents.trim()) {
                lc_wp_popup_message('error', "<?php esc_attr_e("Title and contents can't be empty", PCMA_ML) ?>");
                return false;      
            }
            
            
            let email = prompt(`<?php esc_attr_e('Send a test e-mail to', PCMA_ML) ?>`, '<?php echo esc_attr($current_user->user_email) ?>');
            if(email) {
                email = email.trim();
            }
            if(!email) {
                return false;    
            }
            
            const regex = /\S+@\S+\.\S+/;
            if(!regex.test(email)) {
                lc_wp_popup_message('error', "<?php esc_attr_e('Please use a valid e-mail address', PCMA_ML) ?>");
                return false;
            };
            
            if(!confirm("<?php esc_attr_e('Do you really want to send a demo e-mail to', PCMA_ML) ?> "+ email +"?")) {
                return false;    
            }
            $tab.addClass('pcma_mce_demosending');
            
            // ajax call saving data in transient and retrieving the iframe key
            let data = {
                action      : 'pcma_send_test_email',
                receiver    : email,
                title       : title,
                contents    : contents,
                template_id : (linked_template_f_name && $('select[name="'+ linked_template_f_name +'"]').length) ? $('select[name="'+ linked_template_f_name +'"]').val() : 0,
                nonce       : nonce,
            };
            $.post(ajaxurl, data, function(response) {
                if(response.trim() == 'success') {
                    lc_wp_popup_message('success', "<?php esc_attr_e('E-mail successfully sent!', PCMA_ML) ?>");
                } else {
                    lc_wp_popup_message('error', response);        
                }
            })
            .fail(function(e) {
                if(e.status) {
                    console.error(e);
                    lc_wp_popup_message('error', "<?php esc_attr_e('Error sending the e-mail', PCMA_ML) ?>");
                }    
            })
            .always(function() {
                $tab.removeClass('pcma_mce_demosending');
            });
        });
        
        
        
        
        // show preview mode
        $(document).on('click', '.wp-switch-editor', function(e) {
            if(!$(this).parents('.wp-editor-tabs').find('.pcma-tinymce-preview-tab') || $(this).hasClass('pcma-tinymce-demosend')) {
                return true;    
            }     
            
            const $tab              = $(this), 
                  $wrap             = $tab.parents('.wp-editor-wrap'),
                  $preview_btn      = $tab.parents('.wp-editor-tabs').find('.pcma-mce-preview-tab'),
                  
                  linked_template_f_name    = $wrap.data('pcma-linked-template-f'),
                  $linked_template_f        = (linked_template_f_name && $('select[name="'+ linked_template_f_name +'"]').length) ? $('select[name="'+ linked_template_f_name +'"]') : false;
            
            if($tab.hasClass('pcma-tinymce-preview-tab')) {
                
                let editor_id     = $tab.data('editor-id'),
                    editor_mode   = ($wrap.hasClass('tmce-active')) ? 'mce' : 'text',
                    template_id   = ($linked_template_f) ? $linked_template_f.val() : 0;
                
                window.pcma_mce_load_preview(editor_id, editor_mode, template_id);
                
                if($linked_template_f && !$linked_template_f.hasClass('pcma_mce_evt_attached')) {
                    $linked_template_f.addClass('pcma_mce_evt_attached');
                    
                    $linked_template_f.on('change', function() {
                        editor_mode = ($wrap.hasClass('tmce-active')) ? 'mce' : 'text';
                        window.pcma_mce_load_preview(editor_id, editor_mode, $linked_template_f.val());        
                    });    
                }
                
                setTimeout(function() {
                    $wrap.removeClass('tmce-active html-active').removeClass('tmce-active html-active').addClass('pcma-mce-preview-active');
                }, 10);
                
                $wrap.find('.wp-editor-container').hide();
                $wrap.find('.pcma-mce-preview').show();
                
                $('head').append('<style id="pcma-mce-preview-css-trick">#post-status-info {display: none !important;}</style>');
            }
            else {
                $wrap.find('.wp-editor-container').show();
                $wrap.find('.pcma-mce-preview').hide();
                $('#pcma-mce-preview-css-trick').remove();
                
                if($wrap.hasClass('pcma-mce-preview-active')) {
                    $wrap.removeClass('pcma-mce-preview-active');

                    const to_add = ($tab.hasClass('switch-tmce')) ? 'tmce-active' : 'html-active';
                    $wrap.addClass(to_add);
                }
            }
        });
        
        
        
        
        let cached_preview_data = {};
        window.pcma_mce_load_preview = function(editor_id, editor_mode, template_id) {
            
            const transient_name = (editor_id) ? 'pcma_'+ editor_id +'_mail_preview' : 'pcma_campaign_'+ $('#post_ID').val() +'_mail_preview',
                  d = new Date();
            
            let contents = '',
                $iframe = null; 
            
            // get editor content
            if(!editor_id) { // wp posts
                contents = (editor_mode == 'mce') ? tinyMCE.activeEditor.getContent() : $('textarea.wp-editor-area').val().trim();  
                $iframe = $('.pcma-mce-preview');
            } 
            else if(typeof(tinyMCE.editors[editor_id]) != 'undefined' || $('#'+editor_id).length) {
                contents = (editor_mode == 'mce') ? tinyMCE.editors[editor_id].getContent() : $('#'+editor_id).val().trim();
                $iframe = $('#wp-'+ editor_id +'-wrap').find('.pcma-mce-preview');
            }
            
            if(!$iframe) {
                console.error('pcma_mce_load_preview - editor '+ editor_id +' not found');
                return false;    
            }
            
            const preview_data = {
                contents : contents,
                template : template_id
            };
            
            
            if(typeof(cached_preview_data[transient_name]) == 'undefined') {
                cached_preview_data[transient_name] = {};            
            }
            if(JSON.stringify(cached_preview_data[transient_name]) === JSON.stringify(preview_data)) {
                return true;    
            }
            
            cached_preview_data[transient_name] = preview_data;
            $iframe.attr('src', '');

            // ajax call saving data in transient and retrieving the iframe key
            let data = {
                action      : 'pcma_prepare_mail_preview',
                ts_name     : transient_name,
                contents    : contents,
                template_id : template_id,
                nonce       : nonce,
            };
            $.post(ajaxurl, data, function(response) {
                if(response.trim() == 'success') {
                    $iframe.attr('src', '<?php echo PCMA_URL ?>/mail_preview.php?abspath=<?php echo urlencode(ABSPATH) ?>&subj='+ transient_name +'&'+ d.getTime());
                } else {
                    lc_wp_popup_message('error', response);        
                }
            })
            .fail(function(e) {
                if(e.status) {
                    console.error(e);
                    lc_wp_popup_message('error', "<?php esc_attr_e('Error generating the preview', PCMA_ML) ?>");
                }    
            });
        };
        
        
        
        
        // show emoji picker
        $(document).on('click', '.mce-i-pcma-tinymce_emoji-btn', function(e) {
            const $btn  = $(this).parents('.mce-btn');
            
            if(!$btn.find('.pcma_tept_field').length) {
                $btn.append(`<input type="text" name="pcma_tept_field" class="pcma_tept_field" value="" autocomplete="off" />`);    
                
                
                let emoji_opts = JSON.parse(JSON.stringify(window.pcma_common_emoji_opts));
                emoji_opts.selection_callback = function(emoji, target_field) {
                    tinyMCE.activeEditor.execCommand('mceInsertContent', 0, emoji.querySelector('img').getAttribute('alt'));
                };
                
                new lc_emoji_picker('.pcma_tept_field', emoji_opts);
            }
            
            const $trigger = $btn.find('.lcep-trigger');
            
            // open or close?
            if(!$trigger || !$('#lc-emoji-picker.lcep-shown').length || !$btn[0].contains($trigger[0])) {
                setTimeout(function() {
                    $btn.find('.lcep-trigger').click();
                }, 50);   
                
                active_trigger = $trigger;
            }
            else {
                $('body').click();
                active_trigger = false;
            }    
        });
        
    })(jQuery);    
    </script>    
    <?php
}
